/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyue.tinkers_ingenuity.content.basic.recipes;

import com.xiaoyue.tinkers_ingenuity.TinkersIngenuity;
import com.xiaoyue.tinkers_ingenuity.register.TIItems;
import com.xiaoyue.tinkers_ingenuity.register.TinkerRecipes;
import com.xiaoyue.tinkers_ingenuity.utils.ToolUtils;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.recipe.RecipeResult;
import slimeknights.tconstruct.library.recipe.TinkerRecipeTypes;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationContainer;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationRecipe;
import slimeknights.tconstruct.library.tools.definition.ToolDefinition;
import slimeknights.tconstruct.library.tools.definition.module.material.ToolPartsHook;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.tools.part.IToolPart;
import slimeknights.tconstruct.shared.TinkerMaterials;

public class GloriousSealRecipe
implements ITinkerStationRecipe {
    private final ResourceLocation id;
    public static final ResourceLocation GLORIOUS_KEY = TinkersIngenuity.location("glorious_seal_modifiable");
    public static final ResourceLocation GLORIOUS_META_KEY = TinkersIngenuity.location("glorious_seal_meta");

    public GloriousSealRecipe(ResourceLocation id) {
        this.id = id;
    }

    private boolean checkMeta(ITinkerStationContainer inv) {
        ItemStack paper = ItemStack.f_41583_;
        ItemStack gold_block = ItemStack.f_41583_;
        ItemStack sea_dream_ingo = ItemStack.f_41583_;
        ItemStack manyullyn_ingot = ItemStack.f_41583_;
        for (int i = 0; i < inv.getInputCount(); ++i) {
            ItemStack input = inv.getInput(i);
            if (input.m_150930_(Items.f_42516_)) {
                paper = input;
                continue;
            }
            if (input.m_150930_(Items.f_41912_)) {
                gold_block = input;
                continue;
            }
            if (input.m_150930_((Item)TIItems.SEA_DREAM_INGOT.get())) {
                sea_dream_ingo = input;
                continue;
            }
            if (!input.m_150930_(TinkerMaterials.manyullyn.getIngot())) continue;
            manyullyn_ingot = input;
        }
        return !paper.m_41619_() && !gold_block.m_41619_() && !sea_dream_ingo.m_41619_() && !manyullyn_ingot.m_41619_();
    }

    public boolean matches(ITinkerStationContainer inv, Level level) {
        ToolStack tool = inv.getTinkerable();
        ItemStack stack = inv.getTinkerableStack();
        if (stack.m_41619_() || !stack.m_204117_(TinkerTags.Items.MULTIPART_TOOL)) {
            return false;
        }
        if (tool.getPersistentData().getBoolean(GLORIOUS_KEY)) {
            return false;
        }
        if (ToolUtils.hasMetaIn(tool, "tinkers_ingenuity:splendid")) {
            for (int i = 0; i < inv.getInputCount(); ++i) {
                ItemStack input = inv.getInput(i);
                if (!(input.m_41720_() instanceof IToolPart)) continue;
                List parts = ToolPartsHook.parts((ToolDefinition)tool.getDefinition());
                if (parts.isEmpty()) {
                    return false;
                }
                return this.checkMeta(inv) && parts.stream().anyMatch(p -> p.m_5456_() == input.m_41720_());
            }
        }
        return false;
    }

    public RecipeResult<ItemStack> getValidatedResult(ITinkerStationContainer inv) {
        ToolStack tool = inv.getTinkerable();
        for (int i = 0; i < inv.getInputCount(); ++i) {
            ItemStack input = inv.getInput(i);
            Item item = input.m_41720_();
            if (!(item instanceof IToolPart)) continue;
            IToolPart part = (IToolPart)item;
            ToolStack newTool = tool.copy();
            for (ModifierEntry trait : MaterialRegistry.getInstance().getTraits(part.getMaterial(input).getId(), part.getStatType())) {
                newTool.addModifier(trait.getId(), trait.getLevel());
            }
            newTool.getPersistentData().putBoolean(GLORIOUS_KEY, true);
            newTool.getPersistentData().putString(GLORIOUS_META_KEY, part.getMaterial(input).getId().m_214298_());
            return RecipeResult.success((Object)newTool.createStack());
        }
        return RecipeResult.pass();
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public boolean m_8004_(int h, int w) {
        return true;
    }

    public ItemStack m_8043_() {
        return ItemStack.f_41583_;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TinkerRecipes.GLORIOUS_SEAL_RECIPE.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)TinkerRecipeTypes.TINKER_STATION.get();
    }
}

